# DEAFOP Disaster PHP API (Namecheap Shared Hosting)

This is a minimal PHP REST API + MySQL backend for a **public** disaster reporting app.

## Deploy (cPanel)
1) Create a subdomain (recommended): `api.yourdomain.com`
2) Upload `public/` contents to your web root folder for that subdomain.
   Example: `public_html/api/`
3) Ensure `uploads/` is writable (permissions 755 or 775; depends on server).

## Configure
1) Copy: `public/config.sample.php` → `public/config.php`
2) Edit:
   - DB credentials
   - `uploads.base_url` = `https://api.yourdomain.com/uploads`
   - `app_secret` = long random string

## Database
Import `sql/schema.sql` using phpMyAdmin.

## Create first admin
Generate a password hash (example):
`php -r "echo password_hash('YourStrongPassword', PASSWORD_DEFAULT);"`

Then in phpMyAdmin run:
`INSERT INTO admins (email, password_hash, role) VALUES ('admin@yourdomain.com', 'PASTE_HASH_HERE', 'ADMIN');`

## Endpoints
- GET  `/v1/health`
- POST `/v1/reports` (JSON)
- POST `/v1/reports/{id}/photos` (multipart `photos[]`)
- GET  `/v1/reports?county=Nyeri&limit=100`
- POST `/v1/reports/{id}/flags` (JSON)

Admin:
- POST `/v1/admin/login` → returns bearer token
- POST `/v1/admin/reports/{id}/hide`   (Authorization: Bearer TOKEN)
- POST `/v1/admin/reports/{id}/remove` (Authorization: Bearer TOKEN)

## Important
Because the app is public and images are stored on shared hosting:
- keep strict size limits (already 1MB)
- monitor flags regularly
- consider putting Cloudflare in front of your API for basic protection
