<?php
namespace Src\Lib;

final class Http {
  public static function ok(array $data): void {
    http_response_code(200);
    echo json_encode(['ok' => true, 'data' => $data], JSON_UNESCAPED_SLASHES);
    exit;
  }
  public static function created(array $data): void {
    http_response_code(201);
    echo json_encode(['ok' => true, 'data' => $data], JSON_UNESCAPED_SLASHES);
    exit;
  }
  public static function error(int $status, string $message, array $extra = []): void {
    http_response_code($status);
    $payload = ['ok' => false, 'error' => $message];
    if (!empty($extra)) $payload['extra'] = $extra;
    echo json_encode($payload, JSON_UNESCAPED_SLASHES);
    exit;
  }
  public static function jsonBody(): array {
    $raw = file_get_contents('php://input');
    if ($raw === false || trim($raw) === '') return [];
    $data = json_decode($raw, true);
    return is_array($data) ? $data : [];
  }
}
